﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.IO;

namespace 文書追跡管理サービス {
    public partial class 文書追跡管理サービス : ServiceBase {
        public 文書追跡管理サービス() {
            InitializeComponent();
        }

        readonly int 受信ポート = Properties.Settings.Default.受信ポート;
        readonly string 暫定監視ポート = Properties.Settings.Default.暫定監視ポート;
        readonly int 保存までの受信数 = Properties.Settings.Default.保存までの受信数;
        readonly string 保存日数 = Properties.Settings.Default.保存日数;
        readonly int ログ保存月数 = Properties.Settings.Default.ログ保存月数;
        readonly int パージ時刻 = Properties.Settings.Default.パージ時刻;
        readonly string 開始通知アドレス =Properties.Settings.Default.開始通知アドレス;
        readonly string 障害通知アドレス = Properties.Settings.Default.障害通知アドレス;
        readonly int 保存間隔_分 =Properties.Settings.Default.保存間隔_分;
        readonly string 保存パラメータの場所 = Properties.Settings.Default.保存パラメータの場所;
        readonly string ログの場所 = Properties.Settings.Default.ログの場所;


        Queue<string> que = new Queue<string>();
        System.Threading.AutoResetEvent dataEvent = new System.Threading.AutoResetEvent(false);
        IPEndPoint endPoint = new IPEndPoint(IPAddress.Any, 0);
        string version;
        string hostname = Environment.MachineName;
        string rectext;
        string command;
        System.Threading.Thread procedurethread;
        System.Threading.Thread messagethread;
        volatile bool done;
        UdpClient UDP;
        FileStream stm;
        StreamWriter w;
        string savedtable;
        Dictionary<string, string> logined = new Dictionary<string, string>();

        //サービス開始
        protected override void OnStart(string[] args) {
            string stmFolder = (ログの場所 == "") ? System.AppDomain.CurrentDomain.BaseDirectory : ログの場所;
            string savedTableFolder = (保存パラメータの場所 == "") ? System.AppDomain.CurrentDomain.BaseDirectory : 保存パラメータの場所;
            if(stmFolder.EndsWith("\\"))stmFolder=stmFolder.Remove(stmFolder.Length - 1);
            if(savedTableFolder.EndsWith("\\")) savedTableFolder = savedTableFolder.Remove(savedTableFolder.Length - 1);
            stm = new FileStream(Path.Combine(stmFolder, "messageLog000000.TXT"), FileMode.Append);
            w = new StreamWriter(stm, Encoding.GetEncoding("Shift-Jis"));
            savedtable = Path.Combine(savedTableFolder, @"SavedRcvData.xml");
            System.Reflection.AssemblyName AssemblyName = System.Reflection.Assembly.GetExecutingAssembly().GetName();
            version = AssemblyName.Version.ToString();
            log("{0}文書追跡管理サービス version {1} {2}", Environment.NewLine, version, DateTime.Now);
            log("port number {0} Using.", 受信ポート);
            procedurethread = new System.Threading.Thread(new System.Threading.ThreadStart(this.process1));
            log("process thread is now start..");
            procedurethread.Start();
            myEndPoint = "localhost" + "+" + 受信ポート.ToString();
            UDP = new UdpClient(受信ポート);
            messagethread = new System.Threading.Thread(new System.Threading.ThreadStart(this.messagereceive));
            messagethread.Priority = System.Threading.ThreadPriority.AboveNormal;
            log("recieving thread is now start..");
            messagethread.Start();
            setPurgeTimer();
            setSaveTimer();
            List<string> tos = new List<string>();
            tos.Add(開始通知アドレス);
            メール.send(tos, "文書追跡管理サービス開始", "" + Environment.NewLine);
            w.Flush();
        }

        //サービス終了
        protected override void OnStop() {
            log("server program is now finishing.. {0}", DateTime.Now);
            done = true;
            connected = false;
            UDP.Close();    //受信リスナー強制クローズ
            messagethread.Join();
            PurgeTimer.Dispose();
            SaveTimer.Dispose();
            log("server program finished {0}", DateTime.Now);
            w.Close();
            stm.Close();
        }

        //saveタイマー登録
        private void setSaveTimer() {
            SaveCallback = new System.Threading.TimerCallback(SaveRoutine);
            SaveTimer = new System.Threading.Timer(SaveCallback, null, 保存間隔_分 * 60 * 1000, 保存間隔_分 * 60 * 1000);
        }
        System.Threading.TimerCallback SaveCallback;
        System.Threading.Timer SaveTimer;

        //saveルーチン
        private void SaveRoutine(object state) {
            if(更新cnt > 0) {
                udpsend(myEndPoint, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + hostname + "|SERVR|" + version + "|" + "save");
            }
        }

        //purgeタイマー登録
        private void setPurgeTimer() {
            PurgeCallback = new System.Threading.TimerCallback(PurgeRoutine);
            int firstMiliSecond = Convert.ToInt32(((TimeSpan)(DateTime.Now.AddDays(1).Date.AddHours(パージ時刻) - DateTime.Now)).TotalMilliseconds);
            PurgeTimer = new System.Threading.Timer(PurgeCallback, null, firstMiliSecond, 24 * 3600 * 1000);
        }
        System.Threading.TimerCallback PurgeCallback;
        System.Threading.Timer PurgeTimer;

        //purgeルーチン
        private void PurgeRoutine(object state) {
            udpsend(myEndPoint, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + hostname + "|SERVR|" + version + "|" + "purge");
        }

        //電文受信
        public void messagereceive() {
            try {
                log("receiving thread started.");
                done = false;
                UDP.EnableBroadcast = true;
                while(!done) {
                    try {
                        endPoint.Address = IPAddress.Any;
                        endPoint.Port = 0;
                        byte[] bytes = UDP.Receive(ref endPoint);               //受信待ち
                        rectext = Encoding.UTF8.GetString(bytes, 0, bytes.Length);
                        lock(que) {
                            que.Enqueue(endPoint.Address.ToString() + "+" + endPoint.Port.ToString() + "|" + rectext);//キューイング
                        }
                        dataEvent.Set();                                     //処理スレッド起動
                    }
                    catch(SocketException ex) {
                        System.Threading.Thread.Sleep(50);
                    }
                }
                done = true;
                dataEvent.Set();                                     //処理スレッド起動
                procedurethread.Join();
                log("receiving thread finished.");
            }
            catch(Exception ex) {
                errorcall(ex);
            }
        }

        string myEndPoint;

        //リクエストを処理するプロセス
        int 更新cnt = 0;
        DataSet ds = new DataSet();
        Dictionary<string, string> Dic = new Dictionary<string, string>();
        ShortPathList sht;
        void process1() {
            log("process thread started.");
            //共通パラメータから短パスのリストを作成
            sht = ShortPathList.createInstance();
            //追跡文書情報ロード
            if(System.IO.File.Exists(savedtable)) {
                //保存有り
                ds.ReadXml(savedtable);
                if(ds.Tables.Count > 0) {
                    //内容有り
                    log("entry count in load file is {0}.", ds.Tables[0].Rows.Count);
                    log("purge count is {0}.", 期限超過分削除inDS().ToString());
                    datasetToDic();
                    log("dictionary set count was {0}.", Dic.Count);
                }
                else {
                    //内容無し
                    DataTable dt = new DataTable("RcvData");
                    ds.Tables.Add(dt);
                    dt.Columns.Add("key");
                    dt.Columns.Add("value");
                }
            }
            else {
                //保存無し
                DataTable dt = new DataTable("RcvData");
                ds.Tables.Add(dt);
                dt.Columns.Add("key");
                dt.Columns.Add("value");
            }
            try {
                while(!done) {
                    if(que.Count == 0) {
                        //キュー無し（中断＆起動待ち）
                        dataEvent.WaitOne();
                    }
                    else {
                        //キュー有り
                        lock(que) {
                            quetext = que.Dequeue();
                        }
                        log("⇒{0}", quetext);
                        コマンド処理(quetext);
                        if(更新cnt > 保存までの受信数 || done && 更新cnt > 0) {
                            saveTable();
                            更新cnt = 0;
                        }
                    }
                }
                log("process thread finished.");
            }
            catch(Exception ex) {
                errorcall(ex);
            }
        }
        string quetext;

        //
        private void コマンド処理(string quetext) {
            string[] phrases = quetext.Split('|');
            command = phrases[5];
            switch(command) {
                //* quetextレイアウト
                //0 IPアドレス+ポート番号（Serverで付加）
                //------------------------------------
                //1 日時
                //2 USERIDまたは氏名
                //3 PROGRAM区分(WATCH|TRACK|SERVR|TRANS|COMND)
                //4 version
                //-----------------
                //5 command
                //6 ～parameter1（Path）
                //7 ～parameter2（Documentname）
                //8 ～parameter3（コメント|newDocumentName）
                //9 ～parameter4（緊急度）
                //10 ～parameter5（GUID）
                case "putLog":
                    try {
                        if(phrases[6] == "start") {
                            if(!logined.ContainsKey(phrases[3] + " " + phrases[2])) {
                                logined.Add(phrases[3] + " " + phrases[2], phrases[1] + " " + phrases[4]);
                            }
                        }
                        else {
                            if(phrases[6] == "fin") {
                                if(logined.ContainsKey(phrases[3] + " " + phrases[2])) {
                                    logined.Remove(phrases[3] + " " + phrases[2]);
                                }
                            }
                        }
                    }
                    catch {
                    }
                    break;

                case "logincount":
                    log("logined count are now {0}.", logined.Count);
                    break;

                case "loginname":
                    if(logined.Count == 0) {
                        log("no logined now");
                    }
                    else {
                        foreach(string key in logined.Keys) {
                            log(key + " " + logined[key]);
                        }
                        log("logined count are now {0}.", logined.Count);
                    }
                    break;

                case "putdocumentinfo": //from（追跡ツール|監視ツール）新規登録
                    {
                        if(phrases[3] == "WATCH") {
                            phrases[6] = sht.toShortPath(phrases[6]);
                            if(phrases[6] == "") {
                                log("該当の短パスなし");
                                break;
                            }
                            string key = phrases[6] + "|" + phrases[7];
                            try {
                                Dic.Add(key, deSplit(phrases, "|"));
                            }
                            catch {
                                Dic[key] = deSplit(phrases, "|");
                            }
                        }
                        else {
                            string key = phrases[6] + "|" + phrases[7];
                            if(Dic.ContainsKey(key)) {
                                //キー有り
                                if(Dic[key].Split('|')[2] == phrases[2]) {
                                    //同一人の場合
                                    Dic[key] = quetext;
                                    更新cnt++;
                                }
                                else {
                                    //他人の場合
                                    string dicValue = Dic[key];
                                    dicValue = dicValue.Replace("putdocumentinfo", "statusofput");
                                    udpsend(phrases[0], dicValue.Substring(dicValue.IndexOf("|") + 1));
                                }
                            }
                            else {
                                //キー無し
                                Dic.Add(key, quetext);
                            }
                        }
                        break;
                    }

                case "getdocumentinfo"://from 監視ツール
                    foreach(string key in Dic.Keys) {
                        if((phrases[6] == key.Split('|')[0] || phrases[6].StartsWith(key.Split('|')[0] + "\\"))
                        && (phrases[7] == key.Split('|')[1])) {
                            string dicValue = Dic[key];
                            if(phrases[3] == "WATCH") {
                                if(phrases[0].Split('+')[1] != "2224") {
                                    phrases[0] = phrases[0].Split('+')[0] + "+" + 暫定監視ポート; //監視ツールが入れ替わるまで暫定
                                }
                                udpsend(phrases[0], dicValue.Substring(dicValue.IndexOf("|") + 1));
                            }
                            else {
                                log(dicValue);
                            }
                            break;
                        }
                    }
                    break;

                case "deldocumentinfo"://from 追跡ツール＆コマンドマネージャ
                    if(phrases.Length > 7) {
                        string key = phrases[6] + "|" + phrases[7];
                        if(Dic.ContainsKey(key)) {
                            if(Dic[key].Split('|')[2] == phrases[2] || phrases[3] == "COMND") {//同一人,コマンドの場合のみ
                                Dic.Remove(phrases[6] + "|" + phrases[7]);
                                log("deleted");
                                更新cnt++;
                            }
                        }
                        else {
                            log("not deleted ");
                        }
                    }
                    else {
                        log("deldocumentinfoのパラメータ不足です");
                    }
                    break;

                case "chgdocumentname":  //from 監視ツール＆RenameWatcher
                    bool exist = false;
                    foreach(string key in Dic.Keys) {
                        if((phrases[6] == key.Split('|')[0] || phrases[6].StartsWith(key.Split('|')[0] + "\\"))
                        && (phrases[7] == key.Split('|')[1])) {
                            exist = true;
                            string save = Dic[key];
                            Dic.Remove(key);
                            try {
                                Dic.Add(key.Split('|')[0] + "|" + phrases[8], save.Replace(phrases[7], phrases[8]));
                            }
                            catch(ArgumentException) {
                                log("duplicate key = " + key.Split('|')[0] + "|" + phrases[8]);
                            }
                            更新cnt++;
                            log("changed");
                            break;
                        }
                    }
                    if(!exist) log("not changed");
                    break;

                case "getdocumentname"://from 追跡
                    foreach(string value in Dic.Values) {
                        if(value.Split('|').Length > 10 && "" != value.Split('|')[10] && phrases[6] == value.Split('|')[10]) {
                            udpsend(phrases[0], value.Substring(value.IndexOf("|") + 1));
                            break;
                        }
                    }
                    break;

                case "replacecomment":  //from 監視＆追跡
                    exist = false;
                    foreach(string key in Dic.Keys) {
                        if((phrases[6] == key.Split('|')[0] || phrases[6].StartsWith(key.Split('|')[0] + "\\"))
                        && (phrases[7] == key.Split('|')[1])) {
                            exist = true;
                            string save = Dic[key];
                            string[] dicValueFields = save.Split('|');
                            dicValueFields[8] = phrases[8];
                            dicValueFields[9] = phrases[9];
                            string save2 = string.Join("|", dicValueFields);
                            Dic[key] = save2;
                            更新cnt++;
                            log("comment changed");
                            break;
                        }
                    }
                    if(!exist) log("no changable comment ");
                    break;

                case "count":
                    log("table entry count is {0}", Dic.Count);
                    break;

                case "version":
                    log("version is {0}", version);
                    break;

                case "help":
                    log(" stat, terminate, abort, connect, disconnect, list, listkey, count, save, help, deldocumentinfo ff|nn, logincount, loginname, flush, version, purge");
                    break;

                case "abort":
                    log("{0} {1} aborted", DateTime.Now.ToString("MM/dd HH:mm:ss"), hostname);
                    throw new Exception("abort");

                case "list":
                    foreach(string value in Dic.Values) {
                        log("{0}", value);
                    }
                    log("");
                    log(" {0} entries listing end", Dic.Count);
                    break;

                case "listkey":
                    foreach(string key in Dic.Keys) {
                        log("{0}", key);
                    }
                    log("");
                    log(" {0} keys listing end", Dic.Count);
                    break;

                case "stat":
                    log("{0} {1} stat", DateTime.Now.ToString("MM/dd HH:mm:ss"), hostname);
                    break;

                case "connect":
                    connected = true;
                    connectedRemotePoint = phrases[0];
                    log("{0} {1} connected", DateTime.Now.ToString("MM/dd HH:mm:ss"), hostname);
                    break;

                case "disconnect":
                    log("{0} {1} disconnected", DateTime.Now.ToString("MM/dd HH:mm:ss"), hostname);
                    connected = false;
                    break;

                case "save":
                    更新cnt = 保存までの受信数 + 1;
                    break;

                case "flush":
                    w.Flush();
                    break;

                case "purge":
                    dicToDS();
                    log("purge count is {0}.", 期限超過分削除inDS().ToString());
                    datasetToDic();
                    log("dictionary entry count is {0}.", Dic.Count);
                    break;

                default:
                    log("command case error!: {0}", command);
                    break;
            }
        }

        private string deSplit(string[] phrases, string p) {
            StringBuilder sb = new StringBuilder();
            foreach(string str in phrases) {
                sb.Append(str);
                sb.Append(p);
            }
            sb.Length -= (sb.Length == 0) ? 0 : 1;
            return sb.ToString();
        }

        bool connected = false;
        string connectedRemotePoint;

        private void datasetToDic() {
            Dic.Clear();
            for(int i = 0; i < ds.Tables[0].Rows.Count; i++) {
                if(!Dic.ContainsKey(ds.Tables[0].Rows[i][0].ToString())) {
                    Dic.Add(ds.Tables[0].Rows[i][0].ToString(), ds.Tables[0].Rows[i][1].ToString());
                }
            }
        }

        private int 期限超過分削除inDS() {
            DataRowCollection rows = ds.Tables[0].Rows;
            //string 保存日数 = System.Configuration.ConfigurationManager.AppSettings["保存日数"];
            int delcnt = 0;
            for(int i = rows.Count - 1; i >= 0; i--) {
                string mm_dd_hh_mm_ss = rows[i]["value"].ToString().Split('|')[1];
                string mm_dd = mm_dd_hh_mm_ss.Remove(5);
                string mm = mm_dd.Remove(2);
                string thisyyyy = DateTime.Today.Year.ToString();
                string lastyyyy = (DateTime.Today.Year - 1).ToString();
                string yyyy_mm_dd;
                if(Int16.Parse(mm) > DateTime.Today.Month) {
                    //来月以降12月までを前年分とみなす
                    yyyy_mm_dd = lastyyyy + "/" + mm_dd;
                }
                else {
                    //1月から今月までを今年とみなす
                    yyyy_mm_dd = thisyyyy + "/" + mm_dd;
                }
                TimeSpan ts = TimeSpan.FromDays(Int32.Parse(保存日数));//保存日数
                DateTime dt = DateTime.Parse(yyyy_mm_dd);//登録日
                if(DateTime.Today > (dt + ts)) {
                    rows[i].Delete();
                    delcnt++;
                }
            }
            return delcnt;
        }

        //テーブル保存
        private void saveTable() {
            dicToDS();
            ds.Tables[0].WriteXml(savedtable);
            log("saved. entry count was {0}.", ds.Tables[0].Rows.Count);
        }

        private void dicToDS() {
            ds.Clear();
            foreach(string key in Dic.Keys) {
                DataRow r = ds.Tables[0].NewRow();
                r[0] = key;
                r[1] = Dic[key];
                ds.Tables[0].Rows.Add(r);
            }
        }

        //電文送信
        void udpsend(string IPaddressAndPort, params string[] text)  //送信
        {
            try {
                byte[] bytes = Encoding.UTF8.GetBytes(string.Join("|", text));
                UDP.Send(bytes, bytes.Length, IPaddressAndPort.Split('+')[0], Int32.Parse(IPaddressAndPort.Split('+')[1]));
                log("←{0}←{1}", IPaddressAndPort, string.Join("|", text));
            }
            catch(Exception ex) {
                log("UDP send exception : " + ex.Message + Environment.NewLine);
            }
        }

        //ログ
        void log(string editstring, params object[] editvalue) {
            コマンドマネージャへ転送(editstring, editvalue);
            if(stm.Name.Substring(stm.Name.Length - 10, 6) == DateTime.Today.Year.ToString() + DateTime.Today.Month.ToString("00")) {
                w.WriteLine(editstring, editvalue);
            }
            else {
                //スイッチ
                w.WriteLine("log file switched");
                w.Dispose();
                stm.Dispose();
                stm = new FileStream(ログの場所 + "\\" + "messageLog" + DateTime.Today.Year.ToString() + DateTime.Today.Month.ToString("00") + ".TXT", FileMode.Append);
                w = new StreamWriter(stm, Encoding.GetEncoding("Shift-Jis"));
                w.WriteLine(editstring, editvalue);
                //削除
                File.Delete(ログの場所 + "\\" + "messageLog" + DateTime.Today.AddMonths(-1 * ログ保存月数).Year.ToString() + DateTime.Today.AddMonths(-1 * ログ保存月数).Month.ToString("00") + ".TXT");
                File.Delete(ログの場所 + "\\" + "messageLog" + "000000" + ".TXT");
            }
        }

        private void コマンドマネージャへ転送(string editstring, params object[] editvalue) {
            if(connected) {
                try {
                    byte[] bytes = Encoding.UTF8.GetBytes(string.Format(editstring, editvalue));
                    UDP.Send(bytes, bytes.Length, connectedRemotePoint.Split('+')[0], Int32.Parse(connectedRemotePoint.Split('+')[1]));
                }
                catch {
                }
            }
        }

        //コンティンジェンシー処理
        private void errorcall(Exception ex) {
            if(更新cnt > 0) {
                saveTable();
                log("table saved before error fin.");
            }
            List<string> toAddress = new List<string>();
            toAddress.Clear();
            toAddress.Add(障害通知アドレス);
            メール.send(toAddress, "文書追跡管理サーバー障害発生！！！！！！！", string.Format("{0}{2}{2}{1}", ex.Message, ex.StackTrace, Environment.NewLine));
            log("　{0}{2}{1}{2}　上記エラーが発生したためメールしました。", ex.Message, ex.StackTrace, Environment.NewLine);
            w.Close();
            UDP.Close();
            throw new Exception("エラー処理後の強制終了");
        }

    }
}
